// Arduino-Sketch for DB7SG Dreiermatrix, 2022
// created by Stefan Glöckl, http://www.db7sg.de
//
//                                   "The code is documentation enough!"
//
// I wrote this fast "Sketch-Hack" for my "HF-3x3-Matrix". There are only a few things to adjust, so I decided,
// not to take a touchscreen, e.g. nextion, OLEDs are so small, so I took a LCD2004 with I2C-Interface. It's
// easy to implement, has only two pins and is a robust and simple solution. 

//The things to change are marked with "CHANGE" in a own little section below, scroll a little bit down.



//Includes (only LCD_Library is needed)
#include <LiquidCrystal_I2C.h>

//Used PINs
const int Relay1 = 0;
const int Relay2 = 1;
const int RotaryA = 2;
const int RotaryB = 3;
const int Relay3 = 4;
const int Relay4 = 5;
const int Relay5 = 6;
const int Relay6 = 7;
const int Relay7 = 8;
const int Relay8 = 9;
const int Relay9 = 10;
const int Relay10 = 11;
const int Relay11 = 12;
const int Relay12 = 13;
const int Beeper = A0;
const int RotarySW = A1;
// Res. for other display types: A2
// Res. for other display types: A3
// Display I2C_SDA = A4
// Display I2C_SCL = A5

LiquidCrystal_I2C lcd(0x27, 20, 4);       // Define display 

//Declare variables (not to change!)
String progversion = "V1.10";             //Last change on 16.04.2021
int RotaryA_current;                      //HIGH or LOW of current PIN RotaryA
int RotaryA_last;                         //HIGH or LOW of last PIN RotaryA
int RotarySW_state;                       //HIGH or LOW of Switch-PIN-state
unsigned long RotarySW_lastPressed = 0;   //Stores millis, when button was pressed last
int pos_menu = 1;                         //holds the current state of the menu, let's begin at "1":
                                          //Mainmenu: 1, 2, 3
                                          //Changeant_menu: 101, 102, 103
int pos_menu_last;                        //Saves the menupos, before going to a submenu, to go back to same position
unsigned long lcd_backlight_lastaction = millis();     //Stores millis, when button was pressed last

//------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------CHANGE VARIABLES IN THIS SEKTION TO YOUR NEEDS-------------------------------------------
unsigned long lcd_backlight_timeout = 300;                       //CHANGE: Time in seconds to dark Screen, if no action is done (0: function disabled and backlight is allways on)
bool beep = true;                                                //CHANGE: Beep-Signal, when Rotary-Action
String mainmenu_heading = " 3x3-Matrix   DB7SG ";                //CHANGE: Change this to anything you want to be displayed in the first line, e.g. your callsign (20 chars max.)
String tx_name[3] = { "IC7300", "IC7000", "Reserve" };           //CHANGE: Displayname of the three devices (10 chars max.)
String ant_name[3] = { "Hexbeam", "Endfed", "Dummyload" };       //CHANGE: Displayname of the three antennas (9 chars max.)
int tx_ant[3] = {0, 1, 2};                                       //CHANGE: What antenna should connect with which TX on startup (value can be 0,1 or 2; no TX can have the same antenna)
//------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------



// SETUP-----------------------------------------------------------
void setup() {
  //PIN-Definitions
  pinMode(Relay1, OUTPUT);
  pinMode(Relay2, OUTPUT);
  pinMode(Relay3, OUTPUT);
  pinMode(Relay4, OUTPUT);
  pinMode(Relay5, OUTPUT);
  pinMode(Relay6, OUTPUT);
  pinMode(Relay7, OUTPUT);
  pinMode(Relay8, OUTPUT);
  pinMode(Relay9, OUTPUT);
  pinMode(Relay10, OUTPUT);
  pinMode(Relay11, OUTPUT);
  pinMode(Relay12, OUTPUT);
  pinMode(Beeper, OUTPUT);
  pinMode(RotaryA, INPUT);
  pinMode(RotaryB, INPUT);
  pinMode(RotarySW, INPUT);

  //First state of RotaryA-PIN, High or Low?
  RotaryA_last = digitalRead(RotaryA);

  //Set Beeper to a defined off-state
  digitalWrite(Beeper, LOW);

  //Init display
  lcd.init(); //Start LCD
  lcd.backlight(); //LCD-Backlight on
  
  //Startup display and relays
  splashscreen();
  lcd_mainmenu();
  set_relays();
  
  //***********************For testing
  //Serial.begin(9600);                       Serial.println(" ");
}



// LOOP------------------------------------------------------------
void loop() {
  //Rotary-Section-------------------------------------
  RotaryA_current = digitalRead(RotaryA); // Current state of RotaryA-PIN, High or Low?
  // If the current and the last RotaryA-Statse are different...
  if (RotaryA_current != RotaryA_last  && RotaryA_current == 1){ // ...and only action if state changed to 1, to avoid multiple counts
    doBeep();
    if (digitalRead(RotaryB) == RotaryA_current) { // If RotaryA-state is different from RotaryB-state, there is a rotation in a direction... (If wrong rotation make "==" to "!=" and vice versa)
      if (pos_menu >= 1 && pos_menu <= 3) { //changes in mainmenu
        pos_menu++; if (pos_menu > 3) {pos_menu = 1;}
        lcd_marker_middle(pos_menu);
      }
      if (pos_menu >= 101 && pos_menu <= 103) { //changes in changeant_menu
        pos_menu++; if (pos_menu > 103) {pos_menu = 101;}
        lcd_marker_left(pos_menu - 100);
      }
    } else { // ...else in the other direction
      if (pos_menu >= 1 && pos_menu <= 3) { //changes in mainmenu
        pos_menu--; if (pos_menu < 1) {pos_menu = 3;}
        lcd_marker_middle(pos_menu);
      }
      if (pos_menu >= 101 && pos_menu <= 103) { //changes in changeant_menu
        pos_menu--; if (pos_menu < 101) {pos_menu = 103;}
        lcd_marker_left(pos_menu - 100);
      }  
    }
    lcd_backlight_lastaction = millis(); //Set Backlightcounter to current millis
  }
  RotaryA_last = RotaryA_current; // Save RotaryA-state for the next loop
  
  //Rotary-Switch-Section--------------------------------
  RotarySW_state = digitalRead(RotarySW); //Read Switch-PIN
  if (RotarySW_state == LOW) { //If signal is LOW, button is pressed
    if (millis() - RotarySW_lastPressed > 50) { //Debounce the button with a delay of xxx ms
      if (pos_menu >=1 && pos_menu <=3) {       //from mainmenu to submenu "changeant_menu"
        doBeep();
        pos_menu_last = pos_menu;               //save position, before going to submenu
        pos_menu = tx_ant[pos_menu - 1] + 101;  //now menu is 101, 102 or 103, which is the submenu to change antenna
        lcd_changeant_menu();                   //show antenna select menu            
      } else {
        if (pos_menu >=101 && pos_menu <=103) {                //from submenu "changeant_menu" back to mainmenu
          doDoublebeep();
          set_relay_matrix(pos_menu_last -1, pos_menu - 101);  //set the array tx_ant[] to new values, pos_menu_last - 1 is the tx to change, pos_menu - 101 ist the antenna to change
          pos_menu = pos_menu_last;                            //now pos_menu is the last state
          lcd_mainmenu();                                      //show mainmenu   
          set_relays();                                        //set the relay-positions stored in tx_ant[]            
        }
      }  
    }
    RotarySW_lastPressed = millis(); // Remember last button press event
    lcd_backlight_lastaction = millis(); //Set Backlightcounter to current millis
  }

  //Switch backlight on or off, if needed
  if (millis() > lcd_backlight_lastaction + lcd_backlight_timeout * 1000 && lcd_backlight_timeout > 0) {
    lcd.noBacklight(); //LCD-Backlight off
  } else {
    lcd.backlight(); //LCD-Backlight on   
  }
  delay(1); // A very short delay, it's good for debouncing the Rotary Encoder
}


// FUNCTION lcd_line-------------------------------------------------------
void lcd_line(int row, String textline_left, String textline_right) { //write a complete display line, if textline_right is given, it will be printed at the half of the row.
 lcd.setCursor(0,row);
 lcd.print("                    ");         //delete line
 lcd.setCursor(0,row);
 lcd.print(textline_left);                  //print left string
 lcd.setCursor(11,row);
 lcd.print(textline_right);                 //print right string
}

// FUNCTION lcd_marker_middle----------------------------------------------------
void lcd_marker_middle(int row) { //print menu marker in the middle of row
  lcd.setCursor(10,1); lcd.print(" ");
  lcd.setCursor(10,2); lcd.print(" ");
  lcd.setCursor(10,3); lcd.print(" ");
  lcd.setCursor(10,row); lcd.print((char) 126);
}

// FUNCTION lcd_marker_left-------------------------------------------------------
void lcd_marker_left(int row) { //print menu marker on the left side of row
  lcd.setCursor(0,1); lcd.print(" ");
  lcd.setCursor(0,2); lcd.print(" ");
  lcd.setCursor(0,3); lcd.print(" ");
  lcd.setCursor(0,row); lcd.print((char) 126);
}

// FUNCTION doBeep----------------------------------------------------------------
void doBeep() { //Make a Signal-Beep
  if (beep) {tone(Beeper, 900, 10);}
}

// FUNCTION doBeep_twice-----------------------------------------------------------
void doDoublebeep() { //Make a Signal-Beep
  if (beep) {tone(Beeper, 900, 10); delay(100); tone(Beeper, 900, 10);}
}

// FUNCTION lcd_mainmenu----------------------------------------------------------
void lcd_mainmenu() { //Write complete mainmenu on display, marker is set to pos_menu (pos_menu is 1, 2 or 3)
  lcd_line(0, mainmenu_heading, ""); //Print first line to display
  lcd_line(1,tx_name[0],ant_name[tx_ant[0]]);
  lcd_line(2,tx_name[1],ant_name[tx_ant[1]]);
  lcd_line(3,tx_name[2],ant_name[tx_ant[2]]);
  lcd_marker_middle(pos_menu);  //marker to antenna
}

// FUNCTION lcd_changeant_menu----------------------------------------------------
void lcd_changeant_menu() { //Write complete changeant_menu on display, marker is set to pos_menu (pos_menu is 101, 102 or 103)
  lcd_line(0, "Change " + tx_name[pos_menu_last - 1] + " to", ""); //Print first line to display
  lcd_line(1, " " + ant_name[0], "");
  lcd_line(2, " " + ant_name[1], "");
  lcd_line(3, " " + ant_name[2], "");
  lcd_marker_left(pos_menu - 100); //marker to antenna
}

// FUNCTION set_relay_matrix-------------------------------------------------------
void set_relay_matrix(int tx, int ant) { //set the array tx_ant[] (tx=0,1,2|ant=0,1,2)
  if (tx_ant[0] == ant) {             //switch the tx, which has the requested antenna... 
    tx_ant[0] = tx_ant[tx];
    } else if (tx_ant[1] == ant) {
        tx_ant[1] = tx_ant[tx];
    } else if (tx_ant[2] == ant) {
        tx_ant[2] = tx_ant[tx];
    }
  tx_ant[tx] = ant;                   //...with requested tx 
}

// FUNCTION set_relays--------------------------------------------------------------
void set_relays() { //set the twelve relays on/off (there are six possible setups: 012/021/102/120/201/210) - First set relays to LOW, then to HIGH
  String matrix = String(tx_ant[0]) + String(tx_ant[1]) + String(tx_ant[2]); //matrix holds the string to compare to
  if (matrix == "012") {
    digitalWrite(Relay4, LOW); digitalWrite(Relay5, LOW); digitalWrite(Relay6, LOW); digitalWrite(Relay7, LOW); digitalWrite(Relay8, LOW); digitalWrite(Relay9, LOW);
    digitalWrite(Relay12, LOW); digitalWrite(Relay1, HIGH); digitalWrite(Relay2, HIGH); digitalWrite(Relay3, HIGH); digitalWrite(Relay10, HIGH); digitalWrite(Relay11, HIGH);
  }
  if (matrix == "021") {
    digitalWrite(Relay4, LOW); digitalWrite(Relay5, LOW); digitalWrite(Relay6, LOW); digitalWrite(Relay7, LOW); digitalWrite(Relay9, LOW); digitalWrite(Relay10, LOW);
    digitalWrite(Relay11, LOW); digitalWrite(Relay1, HIGH); digitalWrite(Relay2, HIGH); digitalWrite(Relay3, HIGH); digitalWrite(Relay8, HIGH); digitalWrite(Relay12, HIGH);
  } 
  if (matrix == "102") {
    digitalWrite(Relay1, LOW); digitalWrite(Relay2, LOW); digitalWrite(Relay6, LOW); digitalWrite(Relay8, LOW); digitalWrite(Relay11, LOW); digitalWrite(Relay12, LOW);
    digitalWrite(Relay3, HIGH); digitalWrite(Relay4, HIGH); digitalWrite(Relay5, HIGH); digitalWrite(Relay7, HIGH); digitalWrite(Relay9, HIGH); digitalWrite(Relay10, HIGH); 
  }
  if (matrix == "120") {
    digitalWrite(Relay1, LOW); digitalWrite(Relay3, LOW); digitalWrite(Relay6, LOW); digitalWrite(Relay7, LOW); digitalWrite(Relay8, LOW); digitalWrite(Relay10, LOW);
    digitalWrite(Relay11, LOW); digitalWrite(Relay2, HIGH); digitalWrite(Relay4, HIGH); digitalWrite(Relay5, HIGH); digitalWrite(Relay9, HIGH);  digitalWrite(Relay12, HIGH);
  }
  if (matrix == "201") {
    digitalWrite(Relay1, LOW); digitalWrite(Relay2, LOW); digitalWrite(Relay5, LOW); digitalWrite(Relay9, LOW); digitalWrite(Relay10, LOW); digitalWrite(Relay11, LOW);
    digitalWrite(Relay12, LOW); digitalWrite(Relay3, HIGH); digitalWrite(Relay4, HIGH); digitalWrite(Relay6, HIGH); digitalWrite(Relay7, HIGH); digitalWrite(Relay8, HIGH);
  }
  if (matrix == "210") {
    digitalWrite(Relay1, LOW); digitalWrite(Relay3, LOW); digitalWrite(Relay5, LOW); digitalWrite(Relay7, LOW); digitalWrite(Relay8, LOW); digitalWrite(Relay9, LOW);
    digitalWrite(Relay10, LOW); digitalWrite(Relay12, LOW); digitalWrite(Relay2, HIGH);  digitalWrite(Relay4, HIGH); digitalWrite(Relay6, HIGH); digitalWrite(Relay11, HIGH);
  }
}

// FUNCTION splashscreen-------------------------------------------------------------
void splashscreen() { //show startscreen
  lcd.clear();
  lcd.setCursor(0,0); lcd.print(" S. Gl" "\xEF" "ckl, DB7SG");
  lcd.setCursor(5,1); lcd.print("| " + progversion + " |"); 
  lcd.setCursor(5,2); lcd.print("---------"); 
  lcd.setCursor(0,3); lcd.print("Press for relaytest!");
  delay(2500);
  //Relaytest, if Rotarybutton is pressed
  if (digitalRead(RotarySW) == LOW) { //If signal is LOW, button is pressed
    lcd.setCursor(0,3); lcd.print("                    ");
    lcd.setCursor(0,3); lcd.print("Testing relay 1..."); relaytest(Relay1); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 2..."); relaytest(Relay2); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 3..."); relaytest(Relay3); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 4..."); relaytest(Relay4); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 5..."); relaytest(Relay5); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 6..."); relaytest(Relay6); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 7..."); relaytest(Relay7); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 8..."); relaytest(Relay8); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 9..."); relaytest(Relay9); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 10..."); relaytest(Relay10); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 11..."); relaytest(Relay11); delay(750);
    lcd.setCursor(0,3); lcd.print("Testing relay 12..."); relaytest(Relay12); delay(750);
  }
  doDoublebeep();
}

// FUNCTION relaytest--------------------------------------------------------------
void relaytest(int rel) { //let the Relay "rel" click multiple times to hear the function and/or clean the contacts  
  digitalWrite(rel, HIGH); delay(50); digitalWrite(rel, LOW); delay(50);
  digitalWrite(rel, HIGH); delay(50); digitalWrite(rel, LOW); delay(50);
  digitalWrite(rel, HIGH); delay(50); digitalWrite(rel, LOW); delay(50);
  digitalWrite(rel, HIGH); delay(50); digitalWrite(rel, LOW); delay(50);
  digitalWrite(rel, HIGH); delay(50); digitalWrite(rel, LOW); delay(50);
}


//Special Chars for use in LCDs
// ä: \xE1
// ö: \xEF
// ü: \xF5
// ß: \xE2
// °: \xDF
// µ: \xE4
// Ω: \xF4
